define({"582":{i:0.000101698922902163,u:"../Content/Reference Material/H/HDF Routines/HDF_DFR8_READREF.htm",a:"The HDF_DFR8_READREF procedure sets the reference number of the image to be read from an HDF file by the next call to HDF_DFR8_GETIMAGE. Syntax HDF_DFR8_READREF, Filename , Reference_number Arguments Filename A scalar string containing the name of the file to be read. Reference_number A reference ...",t:"HDF_DFR8_READREF"},"583":{i:0.000101698922902163,u:"../Content/Reference Material/H/HDF Routines/HDF_DFR8_RESTART.htm",a:"HDF_DFR8_RESTART The HDF_DFR8_RESTART procedure causes the next call to HDF_DFR8_GETIMAGE to read from the first image in the HDF file. Syntax HDF_DFR8_RESTART Arguments None Keywords None Version History 4.0 Introduced ",t:"HDF_DFR8_RESTART"},"584":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_DFR8_SETPALETTE.htm",a:"The HDF_DFR8_SETPALETTE procedure sets the current palette to be used for subsequent images in an HDF file. The current palette will be used when adding images with the HDF_DFR8_ADDIMAGE routine. Syntax HDF_DFR8_SETPALETTE, Palette Arguments Palette A 768-element byte array of palette data. This ...",t:"HDF_DFR8_SETPALETTE"},"585":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_DUPDD.htm",a:"The HDF_DUPDD procedure generates new references to existing data in an HDF file. Syntax HDF_DUPDD, FileHandle , NewTag , NewRef , OldTag , OldRef Arguments FileHandle The HDF file handle returned from a previous call to HDF_OPEN. NewTag An integer tag for new data descriptor. NewRef An integer ...",t:"HDF_DUPDD"},"586":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_EXISTS.htm",a:"The HDF_EXISTS function returns True if the HDF scientific data format library is supported on the current IDL platform. This routine is written in the IDL language. Its source code can be found in the file hdf_exists.pro in the lib subdirectory of the IDL distribution. Examples The following IDL ...",t:"HDF_EXISTS"},"587":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_ATTRINFO.htm",a:"This function retrieves the name, data type, and number of values of the attribute for the HDF data object identified by the parameter obj_id. Syntax Result = HDF_GR_ATTRINFO( obj_id , attr_index , name , data_type , count ) Return Value Returns SUCCEED (0) if successful or FAIL (-1) otherwise. ...",t:"HDF_GR_ATTRINFO"},"588":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_CREATE.htm",a:"This function creates an HDF GR raster image. Once a raster image has been created, it is not possible to change its name, data type, dimension sizes or number of pixel components. However, it is possible to create a raster image and close the file before writing any data values to it. Later, the ...",t:"HDF_GR_CREATE"},"589":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_END.htm",a:"This procedure terminates the HDF GR interface session identified by the parameter gr_id . HDF_GR_END, together with HDF_GR_START, define the extent of a HDF GR interface session. HDF_GR_END disposes of the internal structures initialized by the corresponding call to HDF_GR_START. There must be a ...",t:"HDF_GR_END"},"590":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_ENDACCESS.htm",a:"This procedure terminates access to the raster image identified by the parameter ri_id and disposes of the raster image identifier. This access is initiated by either HDF_GR_SELECT or HDF_GR_CREATE. There must be a call to HDF_GR_ENDACCESS for each call to HDF_GR_SELECT or HDF_GR_CREATE; failing to ...",t:"HDF_GR_ENDACCESS"},"591":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_FILEINFO.htm",a:"This function retrieves the number of raster images and the number of global attributes for the HDF GR interface identified by the parameter gr_id , and stores them into the parameters n_images and n_file_attrs , respectively. The term “global attributes” refers to attributes that are assigned to ...",t:"HDF_GR_FILEINFO"},"592":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_FINDATTR.htm",a:"This function finds the index of an HDF data object\u0027s attribute given its attribute name. HDF_GR_FINDATTR returns the index of the attribute whose name is specified by the parameter attr_name for the object identified by the parameter obj_id . Syntax Result = HDF_GR_FINDATTR( obj_id , attr_name ) ...",t:"HDF_GR_FINDATTR"},"593":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_GETATTR.htm",a:"This function obtains all values of the HDF GR attribute that is specified by its index, attr_index , and is attached to the object identified by the parameter obj_id . Syntax Result = HDF_GR_GETATTR( obj_id , attr_index , values ) Return Value Returns SUCCEED (0) if successful or FAIL (-1) ...",t:"HDF_GR_GETATTR"},"594":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_GETCHUNKINFO.htm",a:"This function retrieves chunking information about the HDF GR raster image identified by the parameter ri_id into the parameters dim_length and flag . Note that only chunk dimensions are retrieved; compression information is not available with this function. Syntax Result = HDF_GR_GETCHUNKINFO( ...",t:"HDF_GR_GETCHUNKINFO"},"595":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_GETIMINFO.htm",a:"This function retrieves general information about an HDF GR raster image. HDF_GR_GETIMINFO retrieves the name, number of components, data type, interlace mode, dimension sizes, and number of attributes of the raster image identified by the parameter ri_id . It also retrieves the number of attributes ...",t:"HDF_GR_GETIMINFO"},"596":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_GETLUTID.htm",a:"This function gets the identifier of the HDF GR palette attached to the raster image identified by the parameter ri_id . Syntax Result = HDF_GR_GETLUTID( ri_id , pal_index ) Return Value Returns the palette identifier if successful or FAIL (-1) otherwise. Arguments ri_id Raster image identifier ...",t:"HDF_GR_GETLUTID"},"597":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_GETLUTINFO.htm",a:"This function retrieves the number of pixel components, data type, interlace mode, and number of color lookup table entries of the palette identified by the parameter pal_id . Syntax Result = HDF_GR_GETLUTINFO( pal_id , ncomp , data_type , interlace_mode , num_entries ) Return Value Returns SUCCEED ...",t:"HDF_GR_GETLUTINFO"},"598":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_IDTOREF.htm",a:"This function returns the HDF reference number of the raster image identified by the parameter ri_id . This routine is commonly used for the purpose of annotating the raster image or including the raster image within an HDF Vgroup. The tag number for a GR is 306. Syntax Result = HDF_GR_IDTOREF( ...",t:"HDF_GR_IDTOREF"},"599":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_LUTTOREF.htm",a:"This function returns the HDF reference number of the palette identified by the parameter pal_id . This function is commonly used for the purpose of annotating the palette or including the palette within a HDF Vgroup. Syntax Result = HDF_GR_LUTTOREF( pal_id ) Return Value Returns the reference ...",t:"HDF_GR_LUTTOREF"},"600":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_NAMETOINDEX.htm",a:"This function returns the index of the raster image named gr_name for the HDF GR interface identified by the parameter gr_id . The value of index can be passed into HDF_GR_SELECT to obtain the raster image identifier (ri_id). Syntax Result = HDF_GR_NAMETOINDEX( gr_id , gr_name ) Return Value Returns ...",t:"HDF_GR_NAMETOINDEX"},"601":{i:0.000638042315020327,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_READIMAGE.htm",a:"This function reads the subsample of the HDF GR raster image specified by the parameter ri_id into the variable data . Syntax Result = HDF_GR_READIMAGE( ri_id , data [, EDGE = array ] [, / INTERLACE ] [, START = array ] [, STRIDE = array ] ) Return Value Returns SUCCEED (0) if successful or FAIL ...",t:"HDF_GR_READIMAGE"},"602":{i:0.000366875705816166,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_READLUT.htm",a:"This function reads the palette specified by the parameter pal_id into the pal_data variable. Syntax Result = HDF_GR_READLUT( pal_id , pal_data [, / INTERLACE ] ) Return Value Returns SUCCEED (0) if successful or FAIL (-1) otherwise. Arguments pal_id Palette identifier returned by HDF_GR_GETLUTID. ...",t:"HDF_GR_READLUT"},"603":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_REFTOINDEX.htm",a:"This function returns the index of the HDF GR raster image specified by the parameter gr_ref . Syntax Result = HDF_GR_REFTOINDEX( gr_id , gr_ref ) Return Value Returns the index of the image if successful or FAIL (-1) otherwise. Arguments gr_id HDF GR interface identifier returned by HDF_GR_START. ...",t:"HDF_GR_REFTOINDEX"},"604":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_SELECT.htm",a:"This function obtains the identifier of the HDF GR raster image specified by its index. Syntax Result = HDF_GR_SELECT( gr_id , index ) Return Value Returns the raster image identifier if successful or FAIL (-1) otherwise. Arguments gr_id HDF GR interface identifier returned by HDF_GR_START. index ...",t:"HDF_GR_SELECT"},"605":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_SETATTR.htm",a:"This function attaches the attribute to the HDF GR object specified by the parameter obj_id . The attribute is defined by its name , data type , number of attribute values, and the attribute values. HDF_GR_SETATTR provides a generic way for users to define metadata. It implements the label = value ...",t:"HDF_GR_SETATTR"},"606":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_SETCHUNK.htm",a:"This function makes the HDF GR raster image specified by the parameter ri_id a chunked raster image according to the chunking and compression information provided in the parameters comp_type and comp_prm . Data can be compressed using run-length encoding (RLE), Skipping Huffman or GZIP compression ...",t:"HDF_GR_SETCHUNK"},"607":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_SETCHUNKCACHE.htm",a:"This function allows the user to set the maximum number of chunks to be cached ( maxcache ). If HDF_GR_SETCHUNKCACHE is not called, maxcache is set to the number of chunks along the fastest changing dimension. Syntax Result = HDF_GR_SETCHUNKCACHE( ri_id , maxcache , flags ) Return Value Returns the ...",t:"HDF_GR_SETCHUNKCACHE"},"608":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_SETCOMPRESS.htm",a:"This function specifies the type of compression for the specified HDF GR raster image. Syntax Result = HDF_GR_SETCOMPRESS( ri_id , comp_type , comp_prm ) Return Value Returns SUCCEED (0) if successful or FAIL (-1) otherwise. Arguments ri_id Raster image identifier returned by HDF_GR_CREATE or ...",t:"HDF_GR_SETCOMPRESS"},"609":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_SETEXTERNALFILE.htm",a:"This function causes the specified HDF GR raster image be written to the specified external file, at the specified offset. Data can be moved only once for any given raster image, and it is the user\u0027s responsibility to make sure the external data file is kept with the “original” file. If the raster ...",t:"HDF_GR_SETEXTERNALFILE"},"610":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_START.htm",a:"This function initializes the HDF GR interface for the specified file. This function is used with the HDF_GR_END procedure to define the extent of the HDF GR interface session. As with the start routines in the other interfaces, HDF_GR_START initializes the internal interface structures needed for ...",t:"HDF_GR_START"},"611":{i:9.57090966120056E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_WRITEIMAGE.htm",a:"This function writes the subsample of the raster image data stored in the variable data to the specified raster image. The subsample is defined by the values of the parameters start, stride and edge. The array start specifies the starting location of the subsample to be written. Valid values of each ...",t:"HDF_GR_WRITEIMAGE"},"612":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_GR_WRITELUT.htm",a:"This function writes a palette with the specified palette data and identifier. The palette data itself is stored in the pal_data variable. Syntax Result = HDF_GR_WRITELUT( pal_id , pal_data ) Return Value Returns SUCCEED (0) if successful or FAIL (-1) otherwise. Arguments pal_id Palette identifier ...",t:"HDF_GR_WRITELUT"},"613":{i:0.000366875705816166,u:"../Content/Reference Material/H/HDF Routines/HDF_HDF2IDLTYPE.htm",a:"This function converts an HDF data type code into an IDL variable type code. See the IDL SIZE function and tables 3-2 through 3-4 in Scientific Data Formats for actual values. Examples PRINT, HDF_HDF2IDLTYPE( 6 ) Syntax Result = HDF_HDF2IDLTYPE( hdftypecode ) Return Value Returns the IDL variable ...",t:"HDF_HDF2IDLTYPE"},"614":{i:0.000366875705816166,u:"../Content/Reference Material/H/HDF Routines/HDF_IDL2HDFTYPE.htm",a:"This function converts an IDL variable type code into an HDF data type code. See the IDL SIZE function and tables 3-2 through 3-4 in Scientific Data Formats for actual values. Examples iType = SIZE(5.0d,/TYPE) PRINT, HDF_IDL2HDFTYPE( iType ) Syntax Result = HDF_IDL2HDFTYPE( idltypecode ) Return ...",t:"HDF_IDL2HDFTYPE"},"615":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_ISHDF.htm",a:"The HDF_ISHDF function determines whether or not a specified file in an HDF file. This routine bases its judgement as to whether or not a file is an HDF file on the first few bytes of the file. Therefore, it is possible that HDF_ISHDF will identify the file as an HDF file, but HDF_OPEN will not be ...",t:"HDF_ISHDF"},"616":{i:0.000366875705816166,u:"../Content/Reference Material/H/HDF Routines/HDF_LIB_INFO.htm",a:"The HDF_LIB_INFO procedure returns information about the HDF Library being used by this version of IDL, or information about the version of HDF used to create a particular HDF file. Examples Example 1 HDF_LIB_INFO, MAJOR=MAJOR, MINOR=MINOR, VERSION=VER, RELEASE=REL PRINT, \u0027IDL \u0027, !version.release, \u0027 ...",t:"HDF_LIB_INFO"},"617":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_NEWREF.htm",a:"The HDF_NEWREF function returns the next available reference number for an HDF file. Syntax Result = HDF_NEWREF( FileHandle ) Return Value Returns the next available reference number. Arguments FileHandle The HDF file handle returned from a previous call to HDF_OPEN. Keywords None Version History ...",t:"HDF_NEWREF"},"618":{i:0.000366875705816166,u:"../Content/Reference Material/H/HDF Routines/HDF_NUMBER.htm",a:"The HDF_NUMBER function returns the number of tags in an HDF file or the number of references associated with a given tag. Syntax Result = HDF_NUMBER( FileHandle [, TAG = integer ] ) Return Value Returns either the number of tags in the file or the number of references associated with the specified ...",t:"HDF_NUMBER"},"619":{i:0.00325591362255154,u:"../Content/Reference Material/H/HDF Routines/HDF_OPEN.htm",a:"The HDF_OPEN function opens or creates an HDF file for reading and/or writing. Note that any combination of the READ, WRITE and CREATE keywords is valid. Syntax Result = HDF_OPEN( Filename [, / ALL ] [, / CREATE ] [, NUM_DD = value ] [, / RDWR ] [, / READ ] [, / WRITE ] ) Return Value If successful, ...",t:"HDF_OPEN"},"620":{i:9.57090966120056E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_PACKDATA.htm",a:"This function packs a set IDL variable into an array of raw byte data. It is useful in constructing the input to multi-field HDF Vdata writing routines, such as those found in HDF-EOS, from a set of IDL variables. The packed data is output as an array of bytes which is organized as a number of ...",t:"HDF_PACKDATA"},"621":{i:0.000305555516478691,u:"../Content/Reference Material/H/HDF Routines/HDF_PARSE.htm",a:"The HDF_PARSE function recursively descends through an HDF4 file and creates an ordered hash containing object information and data. This function is not part of the standard HDF interface but is provided as a programming convenience. Its IDL source code is in the file hdf_parse.pro , located in the ...",t:"HDF_PARSE"},"622":{i:0.000389986861643411,u:"../Content/Reference Material/H/HDF Routines/HDF_READ.htm",a:"The HDF_READ function extracts Hierarchical Data Format (HDF), HDF-EOS, and NetCDF data and metadata into an output structure based upon information provided through a graphical user interface or through a file template generated by HDF_BROWSER. If you do not specify a template, the HDF Browser ...",t:"HDF_READ"},"623":{i:0.000188684376025152,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_ADDDATA.htm",a:"The HDF_SD_ADDDATA procedure writes a hyperslab of values to an SD dataset. By default, the output data is transposed. This transposition puts the data in column order, which is more efficient in HDF than row order (which is more efficient in IDL). In the rare cases where it is necessary to write ...",t:"HDF_SD_ADDDATA"},"624":{i:0.000247500760104146,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_ATTRFIND.htm",a:"The HDF_SD_ATTRFIND function locates the index of an HDF attribute given its name. The attribute can be global or from a specific dataset. If an attribute is located, its index is returned. Otherwise, -1 is returned. Once an attribute’s index is known, the HDF_SD_ATTRINFO function can be used to ...",t:"HDF_SD_ATTRFIND"},"625":{i:0.000317627316002205,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_ATTRINFO.htm",a:"The HDF_SD_ATTRINFO procedure reads or retrieves information about an SD attribute. The attribute can be global or from a specific dataset. If an attribute is not present, an error message is printed. Examples ; Open an HDF file and start the SD interface: SDinterface_id = HDF_SD_START(\u0027demo.hdf\u0027) ; ...",t:"HDF_SD_ATTRINFO"},"626":{i:0.000501265705536834,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_ATTRSET.htm",a:"The HDF_SD_ATTRSET procedure writes attributes to an open HDF SD dataset. If no data type is specified, the data type is taken from the Values argument. Examples fid = HDF_OPEN(\u0027demo.hdf\u0027, /ALL) ; Create a new HDF file. SDinterface_id = HDF_SD_START(\u0027demo.hdf\u0027, /RDWR) ; Start the SD interface. ; ...",t:"HDF_SD_ATTRSET"},"627":{i:0.000648837542082965,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_CREATE.htm",a:"The HDF_SD_CREATE function creates and defines a Scientific Dataset (SD) for an HDF file. Keywords can be set to specify the data type. If no keywords are present a floating-point dataset is created. Examples ; Create a new HDF file: SDinterface_id = HDF_SD_START(\u0027test.hdf\u0027, /CREATE) ; Create an ...",t:"HDF_SD_CREATE"},"628":{i:0.000113529903739746,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_DIMGET.htm",a:"The HDF_SD_DIMGET procedure retrieves information about an SD dataset dimension. Examples For an example using this routine, see the example for HDF_SD_DIMSET . Syntax HDF_SD_DIMGET, Dim_ID [, / COUNT ] [, COMPATIBILITY = variable ] [, / FORMAT ] [, / LABEL ] [, / NAME ] [, / NATTR ] [, / SCALE ] ...",t:"HDF_SD_DIMGET"},"629":{i:9.36328983888489E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_DIMGETID.htm",a:"The HDF_SD_DIMGETID function returns a dimension ID given a dataset’s “SDdataset_id” and a dimension number. Examples For an example illustrating this routine, see the documentation for HDF_SD_DIMSET . Syntax Result = HDF_SD_DIMGETID( SDdataset_id , Dimension_Number ) Return Value Returns the ...",t:"HDF_SD_DIMGETID"},"630":{i:0.000113529903739746,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_DIMSET.htm",a:"The HDF_SD_DIMSET procedure sets the scale and data strings for an SD dimension. Examples ; Initialize the SD interface: SDinterface_id = HDF_SD_START(\u0027myhdf.hdf\u0027, /RDWR) ; Create 3 dimensions: SDdataset_id = HDF_SD_CREATE(SDinterface_id, \u0027var1\u0027, [10,20,0], /LONG) ; Select the first dimension: ...",t:"HDF_SD_DIMSET"},"631":{i:0.00025129628219949,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_END.htm",a:"The HDF_SD_END procedure closes the SD interface to an HDF file. Failure to close the file without a call to HDF_SD_END results in the loss of any changed or added SD data. Therefore, HDF_SD_END calls should always be paired with calls to HDF_SD_START. Before HDF_SD_END is called, all access to SD ...",t:"HDF_SD_END"},"632":{i:0.00039886624896659,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_ENDACCESS.htm",a:"The HDF_SD_ENDACCESS procedure closes an SD dataset interface. Failure to close the interface can result in the loss of any changed or added SD data. This routine should be called once for each call to HDF_SD_START or HDF_SD_CREATE. After all SD dataset interfaces are closed, the HDF file can safely ...",t:"HDF_SD_ENDACCESS"},"633":{i:9.13911698107713E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_FILEINFO.htm",a:"The HDF_SD_FILEINFO procedure retrieves the number of datasets and global attributes in an HDF file. Examples ; Start the SD interface: SDinterface_id = HDF_SD_START(\u0027demo.hdf\u0027, /CREATE) ; Set a global attribute: HDF_SD_ATTRSET,SDinterface_id, \u0027TITLE\u0027, \u0027MYTITLE\u0027 ; Set another one: ...",t:"HDF_SD_FILEINFO"},"634":{i:0.000188684376025152,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_GETDATA.htm",a:"The HDF_SD_GETDATA procedure retrieves a hyperslab of values from an SD dataset. By default, the retrieved data is transposed from HDF’s column order format into IDL’s row order which is more efficient in IDL. To retrieve the dataset without this transposition, set the NOREVERSE keyword. Examples ...",t:"HDF_SD_GETDATA"},"635":{i:0.000150613808784559,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_GETINFO.htm",a:"The HDF_SD_GETINFO procedure retrieves information about an SD dataset. Reading a label, unit, format, or coordinate system string that has more than 256 characters can have unpredictable results. Examples For an example using this routine, see the documentation for HDF_SD_SETINFO . Syntax ...",t:"HDF_SD_GETINFO"},"636":{i:0.00108905201556794,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_IDTOREF.htm",a:"The HDF_SD_IDTOREF function converts a SD data set ID into a SD data set reference number. The reference number can be used to add the SD data set to a Vgroup through the HDF_VG interface. The tag number for an SD is 720. Examples ; Create an SD data set and get the Reference number: file_id = ...",t:"HDF_SD_IDTOREF"},"637":{i:5.50327019655568E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_ISCOORDVAR.htm",a:"The HDF_SD_ISCOORDVAR function determines whether or not the specified dataset ID represents a NetCDF “coordinate” variable. Syntax Result = HDF_SD_ISCOORDVAR( SDdataset_id ) Return Value Returns True (1) if the supplied data set ID is a NetCDF coordinate variable. Otherwise, False (0) is returned. ...",t:"HDF_SD_ISCOORDVAR"},"638":{i:0.000475198505981645,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_NAMETOINDEX.htm",a:"The HDF_SD_NAMETOINDEX function returns an SD dataset index given its name and SD interface ID. An error message is printed if the dataset cannot be located. The returned index can be used by HDF_SD_SELECT to access an SD dataset. Examples ; Start the SD interface: SDinterface_id = ...",t:"HDF_SD_NAMETOINDEX"},"639":{i:0.000427955879895214,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_REFTOINDEX.htm",a:"The HDF_SD_REFTOINDEX function returns a scientific dataset’s index given its reference number and SD interface ID. Examples ; Initialize the SD interface: SDinterface_id = HDF_SDSTART(\u0027demo.hdf\u0027) ; Define the reference number for which we want to search: Reference_number = 66 ; Return the index ...",t:"HDF_SD_REFTOINDEX"},"640":{i:0.000815818334936914,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_SELECT.htm",a:"The HDF_SD_SELECT function returns an SD dataset ID given the current SD interface ID, and the zero-based SD dataset index. HDF_SD_FILEINFO can be used to determine the number of SD datasets in an HDF file, HDF_SD_REFTOINDEX can be used to find the index from its SD dataset ID, and ...",t:"HDF_SD_SELECT"},"641":{i:0.000366875705816166,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_SETCOMPRESS.htm",a:"The HDF_SD_SETCOMPRESS procedure compresses an existing HDF SD dataset or sets the compression method of a newly created HDF SD dataset. Available compression methods are No Compression, run-length encoding (RLE), adaptive (skipping) huffman, and GZIP compression. All of these compression methods ...",t:"HDF_SD_SETCOMPRESS"},"642":{i:0.000110110087185909,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_SETEXTFILE.htm",a:"The HDF_SD_SETEXTFILE procedure moves data values from a dataset into an external file. Only the data is moved—all other information remains in the original file. This routine can only be used with HDF version 3.3 (and later) files, not on older HDF files or NetCDF files. Data can only be moved ...",t:"HDF_SD_SETEXTFILE"},"643":{i:9.71531391607205E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_SETINFO.htm",a:"The HDF_SD_SETINFO procedure sets information about an SD dataset. Setting a label, unit, format, or coordinate system string that has more than 256 characters can have unpredictable results. Examples ; Open an HDF file: SDinterface_id = HDF_SD_START(\u0027demo.hdf\u0027, /RDWR) ; Define a new dataset for the ...",t:"HDF_SD_SETINFO"},"644":{i:0.00055605951486047,u:"../Content/Reference Material/H/HDF Routines/HDF_SD_START.htm",a:"The HDF_SD_START function opens or creates an HDF file and initializes the SD interface. Note that every file opened with HDF_SD_START should eventually be closed with a call to HDF_SD_END. Examples ; Open a new HDF file. The file is ready to be accessed: SDinterface_id = HDF_SD_START(\u0027test.hdf\u0027, ...",t:"HDF_SD_START"},"645":{i:9.57090966120056E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_UNPACKDATA.htm",a:"This procedure unpacks an array of byte data into a number of IDL variables. It is useful in deconstructing the output of multi-field HDF Vdata reading routines, such as those found in HDF-EOS, into a set of IDL variables. The packed data is assumed to be an array of bytes that is organized as a ...",t:"HDF_UNPACKDATA"},"646":{i:0.0032501633570707,u:"../Content/Reference Material/H/HDF Routines/HDF_VD_ATTACH.htm",a:"The HDF_VD_ATTACH function accesses a VData with the given Id in an HDF file. Syntax Result = HDF_VD_ATTACH( FileHandle , VData_id [, / READ ] [, / WRITE ] ) Return Value If successful, a handle for that VData is returned, otherwise 0 is returned. Arguments FileHandle The HDF file handle returned ...",t:"HDF_VD_ATTACH"},"647":{i:0.000167527791097042,u:"../Content/Reference Material/H/HDF Routines/HDF_VD_ATTRFIND.htm",a:"The HDF_VD_ATTRFIND function returns an attribute\u0027s index number given the name of an attribute associated with the specified VData or VData/field pair. Examples For an example using this routine, see HDF_VD_ATTRSET . Syntax Result = HDF_VD_ATTRFIND( VData , FieldID , Name ) Return Value Returns the ...",t:"HDF_VD_ATTRFIND"},"648":{i:0.000196007556755519,u:"../Content/Reference Material/H/HDF Routines/HDF_VD_ATTRINFO.htm",a:"The HDF_VD_ATTRINFO procedure reads or retrieves information about a VData attribute or a VData field attribute from the currently attached HDF VData structure. If the attribute is not present, an error message is printed. Examples For an example using this routine, see HDF_VD_ATTRSET . Syntax ...",t:"HDF_VD_ATTRINFO"},"649":{i:0.000196007556755519,u:"../Content/Reference Material/H/HDF Routines/HDF_VD_ATTRSET.htm",a:"The HDF_VD_ATTRSET procedure writes a VData attribute or a VData field attribute to the currently attached HDF VData structure. If no data type keyword is specified, the data type of the attribute value is used. Syntax HDF_VD_ATTRSET, VData , FieldID , Attr_Name , Values [, Count ] [, / BYTE ] [, / ...",t:"HDF_VD_ATTRSET"},"650":{i:0.00143634255987528,u:"../Content/Reference Material/H/HDF Routines/HDF_VD_DETACH.htm",a:"The HDF_VD_DETACH procedure is called when done accessing a VData in an HDF file. This routine must be called for every VData attached for writing before closing the HDF file to insure that VSET information is properly updated. Syntax HDF_VD_DETACH, VData Arguments VData The VData handle returned by ...",t:"HDF_VD_DETACH"},"651":{i:9.57090966120056E-05,u:"../Content/Reference Material/H/HDF Routines/HDF_VD_FDEFINE.htm",a:"The HDF_VD_FDEFINE procedure adds a new field specification for a VData in an HDF file. HDF_VD_FDEFINE can only be used for a new VData. Examples HDF_VD_FDEFINE, vid, \u0027VEL\u0027, /DOUBLE, ORDER=3 Syntax HDF_VD_FDEFINE, VData , Fieldname [, / BYTE | , / DOUBLE | , / FLOAT | , / INT | , / LONG ] [, ORDER = ...",t:"HDF_VD_FDEFINE"},});