define({"77":{i:9.57090966120056E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_ATTGET_ENTRY.htm",a:"The CDF_ATTGET_ENTRY procedure reads a variable attribute entry from a CDF file. Examples id = CDF_OPEN(\u0027test.cdf\u0027) inq = CDF_INQUIRE(id)  ; Read all the variable attribute entries.  ; Walk through all of the zVariables FOR varNum = 0, inq.nzvars-1 DO BEGIN  ; Walk through all of the ZVariable ...",t:"CDF_ATTGET_ENTRY"},"78":{i:7.14036033262812E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_ATTINQ.htm",a:"The CDF_ATTINQ procedure obtains information about a specified attribute in a Common Data Format file. Examples cdfid= CDF_OPEN(\u0027/cdrom/ozone.8.20.92\u0027) CDF_ATTINQ, cdfid, 0, name, scope, maxentry, maxzentry PRINT, name, scope, maxentry, maxzentry Syntax CDF_ATTINQ, Id , Attribute , Name , Scope , ...",t:"CDF_ATTINQ"},"79":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_ATTNUM.htm",a:"The CDF_ATTNUM function returns the attribute number associated with a particular attribute in a Common Data Format file. Examples See the example for CDF_ATTPUT . Syntax Result = CDF_ATTNUM( Id , Attribute_Name ) Return Value Returns the attribute number. Arguments Id The CDF ID for the file that ...",t:"CDF_ATTNUM"},"80":{i:0.000450046934525635,u:"../Content/Reference Material/C/CDF Routines/CDF_ATTPUT.htm",a:"The CDF_ATTPUT procedure writes an attribute entry to a Common Data Format file, or attaches an attribute to a CDF variable. If the specified entry already exists, it is overwritten. Examples Example 1 Id= CDF_CREATE(\u0027foo\u0027, /SUN_ENCODING, /HOST_DECODING, $ /ROW_MAJOR)   ; no dimensions. dummy= ...",t:"CDF_ATTPUT"},"81":{i:7.14036033262812E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_ATTRENAME.htm",a:"The CDF_ATTRENAME procedure is used to rename an existing attribute in a Common Data Format file. Examples See the example for CDF_ATTPUT . Syntax CDF_ATTRENAME, Id , OldAttr , NewName Arguments Id The CDF ID of the file containing the desired attribute, returned from a previous call to CDF_OPEN or ...",t:"CDF_ATTRENAME"},"82":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_CLOSE.htm",a:"The CDF_CLOSE procedure closes the specified Common Data Format file. The CDF’s data buffers are flushed, all of the CDF’s open files are closed, and the CDF identifier is freed. You must use CDF_CLOSE to close a CDF file to guarantee that all modifications you have made are actually written to ...",t:"CDF_CLOSE"},"83":{i:6.63044685156903E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_COMPRESSION.htm",a:"The CDF_COMPRESSION procedure sets or returns the compression mode for a CDF file and/or variables. Compression parameters should be set before values are written to the CDF file. Special Note About Temporary File Location CDF creates temporary files whenever files/variables are compressed or ...",t:"CDF_COMPRESSION"},"84":{i:0.000637736316591788,u:"../Content/Reference Material/C/CDF Routines/CDF_CONTROL.htm",a:"The CDF_CONTROL procedure allows you to obtain or set information for a Common Data Format file, its variables, and its attributes. Syntax CDF_CONTROL, Id [, ATTRIBUTE = name or number ] [, GET_ATTR_INFO = variable ] [, GET_CACHESIZE = variable ] [, GET_COPYRIGHT = variable ] [, GET_FILENAME = ...",t:"CDF_CONTROL"},"85":{i:0.000429559788051624,u:"../Content/Reference Material/C/CDF Routines/CDF_CREATE.htm",a:"The CDF_CREATE function creates a new Common Data Format file with the given filename and dimensions. Note that when you create a CDF file, you may specify both encoding and decoding methods. Encoding specifies the method used to write data to the CDF file. Decoding specifies the method used to ...",t:"CDF_CREATE"},"86":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_DELETE.htm",a:"The CDF_DELETE procedure deletes the specified Common Data Format file. Files deleted include the original .cdf file and the .v0 , .v1 , etc. files if they exist. Examples id = CDF_OPEN(\u0027open_close.cdf\u0027); Open a file. ; ... other CDF_ commands ... CDF_DELETE, id ; Close and Delete the cdf file. ...",t:"CDF_DELETE"},"87":{i:0.00147432775810003,u:"../Content/Reference Material/C/CDF Routines/CDF_DOC.htm",a:"The CDF_DOC procedure retrieves general documentation information about a Common Data Format file. Examples id=CDF_CREATE(\u0027VersionCheck\u0027)   ; Create a CDF file. CDF_DOC, id, vers, rel, copy, INCREMENT=incr PRINT,\u0027File Written Using CDF\u0027, vers, rel, incr, $ FORMAT=\u0027(A,I1,\".\",I1,\"r\",I2)\u0027 CDF_CLOSE, id ...",t:"CDF_DOC"},"88":{i:0.000131524815929203,u:"../Content/Reference Material/C/CDF Routines/CDF_ENCODE_EPOCH.htm",a:"The CDF_ENCODE_EPOCH function encodes a CDF_EPOCH variable into a string. Four different string formats are available. The default (EPOCH=0) is the standard CDF format, which may be parsed by the CDF_PARSED_EPOCH function or broken down with the CDF_EPOCH procedure. Examples epoch_string = ...",t:"CDF_ENCODE_EPOCH"},"89":{i:0.000131524815929203,u:"../Content/Reference Material/C/CDF Routines/CDF_ENCODE_EPOCH16.htm",a:"The CDF_ENCODE_EPOCH16 function encodes a CDF_EPOCH16 value into the standard date and time character string. Examples test_string = \u002704-Dec-2005 20:19:18.176.214.648.000\u0027 test_epoch = CDF_PARSE_EPOCH16(test_string) PRINT, CDF_ENCODE_EPOCH16(test_epoch) IDL Output 04-Dec-2005 ...",t:"CDF_ENCODE_EPOCH16"},"90":{i:0.000423327428128302,u:"../Content/Reference Material/C/CDF Routines/CDF_ENCODE_TT2000.htm",a:"The CDF_ENCODE_TT2000 function encodes a single value or an array of CDF_TIME_TT2000 value(s) into the standard date and time character string(s). The default format of the string is  ISO 8601 format: yyyy-mm-ddThh:mm:ss.cccuuunnn Examples epoch_string = \u00272005-12-04T20:19:18.176321123\u0027 epoch = ...",t:"CDF_ENCODE_TT2000"},"91":{i:0.000927510347633628,u:"../Content/Reference Material/C/CDF Routines/CDF_EPOCH.htm",a:"The CDF_EPOCH procedure computes or breaks down CDF_EPOCH values in a CDF file. When computing an epoch, any missing value is considered to be zero. If you supply a value for the Epoch argument and set the BREAKDOWN_EPOCH keyword, CDF_EPOCH will compute the values of the Year, Month, Day, etc. and ...",t:"CDF_EPOCH"},"92":{i:0.000927510347633628,u:"../Content/Reference Material/C/CDF Routines/CDF_EPOCH16.htm",a:"The CDF_EPOCH16 procedure computes or breaks down a CDF_EPOCH16 value in a CDF file. When computing an epoch, any missing value is considered to be zero. If you supply a value for the Epoch argument and set the BREAKDOWN_EPOCH keyword, CDF_EPOCH16 will compute the values of the Year , Month , Day , ...",t:"CDF_EPOCH16"},"93":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_EPOCH_COMPARE.htm",a:"The CDF_EPOCH_COMPARE function compares two epoch (date and time) values. Values can be scalars or an array of values. The epoch can be one of the CDF formats, CDF_EPOCH, CDF_EPOCH16 or CDF_TIME_TT2000. While data of type CDF_EPOCH and CDF_EPOCH16 can be compared with each other, data in ...",t:"CDF_EPOCH_COMPARE"},"94":{i:0.000366875705816166,u:"../Content/Reference Material/C/CDF Routines/CDF_EPOCH_DIFF.htm",a:"The CDF_EPOCH_DIFF function compares two epoch (date and time) values and returns the difference in milliseconds (default) or microseconds. Examples CDF_EPOCH, epoch, 2005,6,1,10,18,17,2,/COMPUTE CDF_EPOCH, epoch1, 2005,6,1,10,18,17,2,3,4,5,/COMPUTE CDF_EPOCH, epoch2, ...",t:"CDF_EPOCH_DIFF"},"95":{i:6.26388529835927E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_EPOCH_TOJULDAYS.htm",a:"The CDF_EPOCH_TOJULDAYS function converts CDF epoch values in CDF_EPOCH, CDF_EPOCH16 or  CDF_TIME_TT2000 data type to Julian days. This function is similar to the IDL JULDAY function. Examples CDF_VARGET, id, \"Epoch\", epoch, REC_COUNT=1000,/ZVARIABLE ret = CDF_EPOCH_TOJULDAYS (epoch) ret2 = ...",t:"CDF_EPOCH_TOJULDAYS"},"96":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_ERROR.htm",a:"The CDF_ERROR function returns a a short explanation of a given status code returned from a Common Data Format file. Syntax Result = CDF_ERROR( Status ) Return Value Returns a string containing a status code explanation. Arguments Status The status code to be explained. Keywords None Version History ...",t:"CDF_ERROR"},"97":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_EXISTS.htm",a:"The CDF_EXISTS function returns true if the Common Data Format (CDF) scientific data format library is supported on the current IDL platform. This routine is written in the IDL language. Its source code can be found in the file cdf_exists.pro in the lib subdirectory of the IDL distribution. Examples ...",t:"CDF_EXISTS"},"98":{i:0.000251317465232884,u:"../Content/Reference Material/C/CDF Routines/CDF_INQUIRE.htm",a:"The CDF_INQUIRE function returns global information about the Common Data Format file. The tags of this structure are described below. Examples cdfid = CDF_CREATE(\u0027CDFinquire\u0027, /HP_ENCODING, /MAC_DECODING) attr1_id = CDF_ATTCREATE(cdfid, \u0027GLOBAL_ATT\u0027, /GLOBAL_SCOPE) attr2_id = ...",t:"CDF_INQUIRE"},"99":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_LEAPSECONDS_INFO.htm",a:"The CDF_LEAPSECONDS_INFO function returns a structure containing information about the leap seconds used by CDF. Example info = CDF_LEAPSECONDS_INFO() help, info, /struct print, info Syntax Result = CDF_LEAPSECONDS_INFO( ) Return Value The returned structure has the form: { USE_FILE: 1, ...",t:"CDF_LEAPSECONDS_INFO"},"100":{i:0.000223348292130724,u:"../Content/Reference Material/C/CDF Routines/CDF_LIB_INFO.htm",a:"The CDF_LIB_INFO procedure returns information about the CDF Library being used by this version of IDL. Information about the version of CDF used to create a particular CDF file can be obtained through CDF_DOC. Examples CDF_LIB_INFO, VERSION=V, RELEASE=R, COPYRIGHT=C, $ INCREMENT=I PRINT, \u0027IDL \u0027, ...",t:"CDF_LIB_INFO"},"101":{i:0.000442018515141285,u:"../Content/Reference Material/C/CDF Routines/CDF_OPEN.htm",a:"The CDF_OPEN function opens an existing Common Data Format file. Examples id = CDF_OPEN(\u0027open_close.cdf\u0027)   ; Open a file. ; ... other CDF_ commands ... CDF_CLOSE, id ; Close the cdf file. Syntax Result = CDF_OPEN( Filename [, / READONLY ] ) Return Value If successful, the CDF ID for the file is ...",t:"CDF_OPEN"},"102":{i:9.22980960244313E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_PARSE_EPOCH.htm",a:"The CDF_PARSE_EPOCH function parses a properly-formatted input string into a double-precision value properly formatted for use as a CDF_EPOCH variable. CDF_EPOCH variables may be unparsed into a variety of formats using the CDF_ENCODE_EPOCH function. Examples test_string = \u002704-Dec-1995 20:19:18.176\u0027 ...",t:"CDF_PARSE_EPOCH"},"103":{i:9.22980960244313E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_PARSE_EPOCH16.htm",a:"The CDF_PARSE_EPOCH16 function parses a properly-formatted input string into a double-complex value properly formatted for use as a CDF_EPOCH16 variable. CDF_EPOCH16 variables may be unparsed into a variety of formats using the CDF_ENCODE_EPOCH16 or CDF_EPOCH16 functions. Example test_string = ...",t:"CDF_PARSE_EPOCH16"},"104":{i:0.000297072252312621,u:"../Content/Reference Material/C/CDF Routines/CDF_PARSE_TT2000.htm",a:"The CDF_PARSE_TT2000 function parses a single or an array of input strings into an 8-byte integer (LONG64) value(s) for use as a CDF_TIME_TT2000 type variable. CDF_TIME_TT2000 variables may be encoded into a variety of formats using the CDF_ENCODE_EPOCH function or decomposed into date/time ...",t:"CDF_PARSE_TT2000"},"105":{i:0.0015838586411375,u:"../Content/Reference Material/C/CDF Routines/CDF_SET_CDF27_BACKWARD_C.htm",a:"The CDF_SET_CDF27_BACKWARD_COMPATIBLE procedure allows users of IDL version 6.3 and later to create a CDF file that can be read by IDL 6.2 or earlier, or by CDF version 2.7.2 or earlier. By default, a CDF file created by IDL 6.3 or later cannot be read by earlier versions. This procedure must be ...",t:"CDF_SET_CDF27_BACKWARD_COMPATIBLE"},"106":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_SET_MD5CHECKSUM.htm",a:"The CDF_SET_MD5CHECKSUM procedure calculates and inserts a MD5 checksum into a CDF file. If you use the /REMOVE keyword, a previously-inserted checksum is removed from the file. By default, the checksums are not inserted into new files. Once the checksum is inserted into a particular file, a data ...",t:"CDF_SET_MD5CHECKSUM"},"107":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_SET_VALIDATE.htm",a:"The CDF_SET_VALIDATE procedure ensures that file data values are validated when CDF files are opened. The purpose of data checking is to uncover security problems (buffer overflow, for example) caused by compromised CDF files. The data validation process involves extra processing overhead, so turn ...",t:"CDF_SET_VALIDATE"},"108":{i:0.000430933579146338,u:"../Content/Reference Material/C/CDF Routines/CDF_TT2000.htm",a:"The CDF_TT2000 procedure computes or breaks down CDF_TIME_TT2000 values in a CDF file. When computing an epoch, any missing value is considered to be zero. If you supply a value for the Epoch argument and set the BREAKDOWN_EPOCH keyword, CDF_TT2000 will compute the values of the Year, Month, Day, ...",t:"CDF_TT2000"},"109":{i:0.00084966080167904,u:"../Content/Reference Material/C/CDF Routines/CDF_VARCREATE.htm",a:"The CDF_VARCREATE function creates a new variable in a Common Data Format file. In CDF, variable is a generic name for an object that represents data. Data can be scalar (0-dimensional) or multi-dimensional (up to 10-dimensional). Data does not have any associated scientific context; it could ...",t:"CDF_VARCREATE"},"110":{i:6.63044685156903E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_VARDELETE.htm",a:"The CDF_VARDELETE procedure deletes a variable from a SINGLE_FILE CDF file. Note that the variable’s entries are also deleted, and that the variables that numerically follow the deleted variable within the CDF file are automatically renumbered. CDF rVariables and zVariables are counted separately ...",t:"CDF_VARDELETE"},"111":{i:0.00164715727760033,u:"../Content/Reference Material/C/CDF Routines/CDF_VARGET.htm",a:"The CDF_VARGET procedure reads multiple values from a Common Data Format file variable. By default, all elements of a record are read. If INTERVAL and/or OFFSET are specified but no COUNT is specified, CDF_VARGET attempts to get as many elements of each record as possible. Examples ; Create a CDF ...",t:"CDF_VARGET"},"112":{i:0.000108937194063371,u:"../Content/Reference Material/C/CDF Routines/CDF_VARGET1.htm",a:"The CDF_VARGET1 procedure reads one value from a CDF file variable. Examples See the example for CDF_VARCREATE . Syntax CDF_VARGET1, Id , Variable , Value [, OFFSET = vector ] [, REC_START = record ] [, / STRING {data in CDF file must be type CDF_CHAR or CDF_UCHAR}] [, / ZVARIABLE ] Arguments Id The ...",t:"CDF_VARGET1"},"113":{i:0.000168256067174945,u:"../Content/Reference Material/C/CDF Routines/CDF_VARINQ.htm",a:"The CDF_VARINQ function returns a structure containing information about the specified variable in a Common Data Format file. Examples See the example for CDF_VARGET . Syntax Result = CDF_VARINQ( Id , Variable [, / ZVARIABLE ] ) Return Value The returned structure has the form: { IS_ZVAR:0, NAME:\"\", ...",t:"CDF_VARINQ"},"114":{i:6.63044685156903E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_VARNUM.htm",a:"The CDF_VARNUM function returns the variable number associated with a given variable name in a Common Data Format file. Examples See the example for CDF_VARGET . Syntax Result = CDF_VARNUM( Id , VarName [, IsZVar ] ) Return Value Returns the variable number of a specified variable name. If the ...",t:"CDF_VARNUM"},"115":{i:6.98828078775762E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_VARPUT.htm",a:"The CDF_VARPUT procedure writes a value to a variable in a Common Data Format file. This function provides equivalent functionality to the C routines CDFvarPut and CDFvarHyperPut. Examples id= CDF_CREATE(\u0027mycdf\u0027, [5,10], /NETWORK_ENCODING, /ROW_MAJOR) varid= CDF_VARCREATE(id, \u0027V1\u0027, [1,1], ...",t:"CDF_VARPUT"},"116":{i:9.57090966120056E-05,u:"../Content/Reference Material/C/CDF Routines/CDF_VARRENAME.htm",a:"The CDF_VARRENAME procedure renames an existing variable in a Common Data Format file. Examples See the example for CDF_VARGET . Syntax CDF_VARRENAME, Id , OldVariable , NewName [, / ZVARIABLE ] Arguments Id The CDF ID, returned from a previous call to CDF_OPEN or CDF_CREATE. OldVariable A string ...",t:"CDF_VARRENAME"},"117":{i:0.000209794368470491,u:"../Content/Reference Material/C/CEIL.htm",a:"The CEIL function returns the closest integer greater than or equal to its argument. Examples To print the ceiling function of 5.1, enter: PRINT, CEIL(5.1) ; IDL prints: 6 To print the ceiling function of 3000000000.1, the result of which is too large to represent in a 32-bit integer: PRINT, ...",t:"CEIL "},"118":{i:5.52317565356281E-05,u:"../Content/Reference Material/C/CHEBYSHEV.htm",a:"The CHEBYSHEV function returns the forward or reverse Chebyshev polynomial expansion of a set of data. Note: Results from this function are subject to roundoff error given discontinuous data. This routine is written in the IDL language. Its source code can be found in the file chebyshev.pro in the ...",t:"CHEBYSHEV"},"119":{i:0.000407065194171608,u:"../Content/Reference Material/C/CHECK_MATH.htm",a:"The CHECK_MATH function returns and clears the accumulated math error status. Examples To simply check and clear the accumulated math error status using all the defaults, enter: PRINT, CHECK_MATH() IDL prints the accumulated math error status code and resets to zero. For more examples, please see ...",t:"CHECK_MATH "},"120":{i:0.000408032265503576,u:"../Content/Reference Material/C/CHISQR_CVF.htm",a:"The CHISQR_CVF function computes the cutoff value V in a chi-square distribution with Df degrees of freedom such that the probability that a random variable X is greater than V is equal to a user-supplied probability P . This routine is written in the IDL language. Its source code can be found in ...",t:"CHISQR_CVF "},"121":{i:0.000486180480269618,u:"../Content/Reference Material/C/CHISQR_PDF.htm",a:"The CHISQR_PDF function computes the cumulative distribution function for a chi-square distribution with Df degrees of freedom. This is the probability P that, in a chi-square distribution, a random variable X is less than or equal to a user-specified cutoff value V . This routine is written in the ...",t:"CHISQR_PDF "},"122":{i:0.000345906168446078,u:"../Content/Reference Material/C/CHOLDC.htm",a:"Given a positive-definite symmetric n by n array A , the CHOLDC procedure constructs its Cholesky decomposition A = LL T , where L is a lower triangular array and L T is the transpose of L . CHOLDC is based on the routine choldc described in section 2.9 of Numerical Recipes in C: The Art of ...",t:"CHOLDC "},"123":{i:0.000645221639837383,u:"../Content/Reference Material/C/CHOLSOL.htm",a:"The CHOLSOL function returns an n -element vector containing the solution to the set of linear equations Ax = b, where A is the positive-definite symmetric array returned by the CHOLDC procedure. CHOLSOL is based on the routine cholsl described in section 2.9 of Numerical Recipes in C: The Art of ...",t:"CHOLSOL "},"124":{i:8.88539542044977E-05,u:"../Content/Reference Material/C/CINDGEN.htm",a:"The CINDGEN function returns a complex, single-precision, floating-point array with the specified dimensions. Each element of the array has its real part set to the value of its one-dimensional subscript. The imaginary part is set to zero. For example, C=CINDGEN(100) will create a 100-element, ...",t:"CINDGEN"},"125":{i:0.00031904961110989,u:"../Content/Reference Material/C/CIR_3PNT.htm",a:"The CIR_3PNT procedure returns the radius and center of a circle, given 3 points on the circle. This is analogous to finding the circumradius and circumcircle of a triangle; the center of the circumcircle is the point at which the three perpendicular bisectors of the triangle formed by the points ...",t:"CIR_3PNT "},"126":{i:0.000415777932879682,u:"../Content/Reference Material/C/CLIPBOARD.htm",a:"The CLIPBOARD class provides methods to access the system clipboard. Because these are implemented as static methods, you do not need to create an instance of the class. Methods Clipboard::Get (Retrieve the contents of the system clipboard) Clipboard::Set (Sets the system clipboard) Examples First ...",t:"CLIPBOARD"},"127":{i:0.000594794611035572,u:"../Content/Reference Material/C/CLOSE.htm",a:"The CLOSE procedure closes the file units specified as arguments. All open files are also closed when IDL exits. Examples If file units 1 and 3 are open, they can both be closed at the same time by entering the command: CLOSE, 1, 3 Syntax CLOSE[, Unit 1 , ..., Unit n ] [, / ALL ] [, EXIT_STATUS = ...",t:"CLOSE"},"128":{i:0.000101033761427356,u:"../Content/Reference Material/C/CLUST_WTS.htm",a:"The CLUST_WTS function computes the weights (the cluster centers) of an n -column, m -row array, where n is the number of variables and m is the number of observations or samples. CLUST_WTS uses k -means clustering. With this technique, CLUST_WTS starts with k random clusters and then iteratively ...",t:"CLUST_WTS "},"129":{i:0.000101033761427356,u:"../Content/Reference Material/C/CLUSTER.htm",a:"The CLUSTER function computes the classification of an n -column, m -row array, where n is the number of variables and m is the number of observations or samples. CLUST_WTS uses k -means clustering. With this technique, CLUST_WTS starts with k random clusters and then iteratively moves items between ...",t:"CLUSTER "},"130":{i:0.00057593061049178,u:"../Content/Reference Material/C/CLUSTER_TREE.htm",a:"The CLUSTER_TREE function computes the hierarchical clustering for a set of m items in an n -dimensional space. The CLUSTER_TREE function is designed to be used with the DENDROGRAM or DENDRO_PLOT procedures. This routine is written in the IDL language. Its source code can be found in the file ...",t:"CLUSTER_TREE"},"131":{i:0.000148741614962283,u:"../Content/Reference Material/C/CMYK_CONVERT.htm",a:"The CMYK_CONVERT procedure converts from the CMYK (cyan-magenta-yellow-black) color model to RGB (red-green-blue) and vice versa. The procedure uses the following method to convert from CMYK to RGB: R = (255 - C) (1 - K/255) G = (255 - M) (1 - K/255) B = (255 - Y) (1 - K/255) To convert from RGB to ...",t:"CMYK_CONVERT"},"132":{i:0.000182261815058146,u:"../Content/Reference Material/C/CODE_COVERAGE.htm",a:"The CODE_COVERAGE function returns information on which lines of code within a routine were not executed. You can use the CODE_COVERAGE function to find unneeded code paths within your IDL code, or to determine if your unit tests are exercising all of your code. IDL automatically keeps track of code ...",t:"CODE_COVERAGE"},"133":{i:0.000130925249872222,u:"../Content/Reference Material/C/COLOR_CONVERT.htm",a:"The COLOR_CONVERT procedure converts colors to and from the RGB (Red Green Blue) and a number of other color spaces. RGB values are bytes in the range 0 to 255. YCbCr values are bytes with the range indicated below. Other values are in floating point. These color spaces and their ranges are: HLS Hue ...",t:"COLOR_CONVERT "},"134":{i:0.000366875705816166,u:"../Content/Reference Material/C/COLOR_EXCHANGE.htm",a:"The COLOR_EXCHANGE procedure replaces image pixels of a given color with pixels of a new color. For multi-channel images, every image color channel must match the specified color in order for replacement to occur. Specify a threshold value to replace colors close to the specified color. Examples ...",t:"COLOR_EXCHANGE"},"135":{i:0.00193277941893188,u:"../Content/Reference Material/C/COLOR_QUAN.htm",a:"The COLOR_QUAN function quantizes a TrueColor image and returns a pseudo-color image and palette to display the image on standard pseudo-color displays. The output image and palette can have from 2 to 256 colors. COLOR_QUAN solves the general problem of accurately converting a decomposed color ...",t:"COLOR_QUAN "},"136":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/COLOR_RANGE_MAP.htm",a:"The COLOR_RANGE_MAP function maps all the pixels of an image to another set of pixels, using source and target ranges to control the mapping. The mapping is performed on each image channel individually. Channel values falling within the source range are linearly mapped to the target range. The same ...",t:"COLOR_RANGE_MAP"},"137":{i:0.000212383741616594,u:"../Content/Reference Material/C/COLORBAR.htm",a:"With the COLORBAR function, you can add a colorbar annotation to an existing IDL Graphic, or create a colorbar from scratch. Example ; Import and display Maroon Bells data. file = FILEPATH(\u0027surface.dat\u0027, $ SUBDIR=[\u0027examples\u0027,\u0027data\u0027]) data = READ_BINARY(file, DATA_DIMS=[350,450], $ DATA_TYPE=2, ...",t:"COLORBAR"},"138":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/COLORIZE_SAMPLE.htm",a:"The COLORIZE_SAMPLE function colorizes a grayscale image by matching luminance levels with an RGB sample table. This is done by finding any matches between the luminance values in the source image and the luminance values of the RGB sample color table. Matching luminance values are replaced with the ...",t:"COLORIZE_SAMPLE"},"139":{i:5.77047329653662E-05,u:"../Content/Reference Material/C/COLORMAP_APPLICABLE.htm",a:"The COLORMAP_APPLICABLE function determines whether the current visual class supports the use of a colormap, and if so, whether colormap changes affect pre-displayed Direct Graphics or if the graphics must be redrawn to pick up colormap changes. This routine is written in the IDL language. Its ...",t:"COLORMAP_APPLICABLE "},"140":{i:5.50327019655568E-05,u:"../Content/Reference Material/C/COLORMAP_GRADIENT.htm",a:"The COLORMAP_GRADIENT function maps an image into a specified luminance-based gradient. This function can be used to apply a “false” color to an image, based on image luminance levels. Examples The following example maps an entire image into a blue gradient: ; Read a TrueColor image: file = ...",t:"COLORMAP_GRADIENT"},"141":{i:0.000366875705816166,u:"../Content/Reference Material/C/COLORMAP_ROTATION.htm",a:"The COLORMAP_ROTATION function maps pixels within a given hue range to another hue range, using the HSV hue component. The HSV color model describes the hue component as a circular value from 0 to 360 degrees where red is located at 0 degrees, green is 120 degrees, and blue is 240 degrees. A hue ...",t:"COLORMAP_ROTATION"},"142":{i:0.000190853823869233,u:"../Content/Reference Material/C/COLORTABLE.htm",a:"With the COLORTABLE function, you can specify the parameters to create a custom color table  or load a system color table with specified parameters. Example The following lines create the graphic shown at the top of this topic. ; Define the color table levels = 10 ctable = ...",t:"COLORTABLE"},"143":{i:0.000449006012945966,u:"../Content/Reference Material/C/COMFIT.htm",a:"The COMFIT function fits the paired data { xi , yi } to one of six common types of approximating models using a gradient-expansion least-squares method. This routine is written in the IDL language. Its source code can be found in the file comfit.pro in the lib subdirectory of the IDL distribution. ...",t:"COMFIT "},"144":{i:0.000307423849288253,u:"../Content/Reference Material/C/COMMAND_LINE_ARGS.htm",a:"The COMMAND_LINE_ARGS function returns strings supplied by the user when IDL was started with the -arg or -args command line options. If either of these options is specified at the command line when IDL is started, IDL saves them without examining their values or attaching any special meaning to ...",t:"COMMAND_LINE_ARGS"},"145":{i:5.79563159634795E-05,u:"../Content/Reference Material/C/COMMON.htm",a:"The COMMON statement creates or references a common block. Common blocks are useful when there are variables that need to be accessed by several IDL procedures or when the value of a variable within a procedure must be preserved across calls. Once a common block has been defined, any program unit ...",t:"COMMON "},"146":{i:0.000696421447970888,u:"../Content/Reference Material/C/COMPILE_OPT.htm",a:"The COMPILE_OPT statement allows you to give the IDL compiler information that changes some of the default rules for compiling the function or procedure within which the COMPILE_OPT statement appears. We recommend the use of COMPILE_OPT IDL2 in all new code intended for use in a reusable library. We ...",t:"COMPILE_OPT "},"147":{i:0.000619904449264915,u:"../Content/Reference Material/C/COMPLEX.htm",a:"The COMPLEX function returns complex scalars or arrays given one or two scalars or arrays. Examples Create a complex array from two integer arrays by entering the following commands: ; Create the first integer array: A = [1,2,3] ; Create the second integer array: B = [4,5,6] ; Make A the real parts ...",t:"COMPLEX "},"148":{i:0.000532231162563214,u:"../Content/Reference Material/C/COMPLEXARR.htm",a:"The COMPLEXARR function returns a complex, single-precision, floating-point vector or array. Examples To create an empty, 5-element by 5-element, complex array C, enter: C = COMPLEXARR(5, 5) Syntax Result = COMPLEXARR( D 1 [ , ..., D 8 ] [, / NOZERO ] ) Return Value Returns a complex, ...",t:"COMPLEXARR"},});